;EARTHRES450.ASM 14MAR03 - JOHN BECKER - EPE EARTH RESISTIVITY LOGGER

;PIC16F876 3.6864MHz xtal, WDT off, POR on
; written in TASM for TK3 assembly

                LIST P = PIC16F876,R=DEC
                __config H'3F31' 

#DEFINE BANK0 BCF 3,5    ; status bit 5
#DEFINE BANK1 BSF 3,5    ; status bit 5
#DEFINE BLOCK0 BCF $03,7 ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF $03,7 ; set   STATUS bit 7 (IRP)

		include P16F876.inc

LOOPA:      .EQU $20     ;loop counter 2 - LCD use only
STORE1:     .EQU $21     ;general store 1
CLKCNT:     .EQU $22     ;pre-counter for CLOCK
RSLINE:     .EQU $23     ;RS line flag for LCD
SQUAREWAVE: .EQU $24     ; output waveform
COUNT0      .EQU $25     ; lsb
COUNT1      .EQU $26     ; nsb
COUNT2      .EQU $27     ; msb
DIGIT1      .EQU $28     ; lsd digital conversion
DIGIT2      .EQU $29
DIGIT3      .EQU $2A
DIGIT4      .EQU $2B
DIGIT5      .EQU $2C
DIGIT6      .EQU $2D
DIGIT7      .EQU $2E
DIGIT8      .EQU $2F     ; msd digital conversion

BITCNT      .EQU $30     ; maths routine counter
DIGCNT      .EQU $31     ; maths routine counter
MEMHI:      .EQU $32     ; msb val to be sent to eeprom chip
MEMLO:      .EQU $33     ; lsb val to be sent to eeprom chip
CHAN:       .EQU $34
BCOUNT:     .EQU $35
COUNT:      .EQU $36
DATAI:      .EQU $37
DATAO:      .EQU $38
EEPROM:     .EQU $39
MODE:       .EQU $3A
STORE2:     .EQU $3B     ; temp store
MULCLSB:    .EQU $3C     ; multiplicant LSB
MULCMSB:    .EQU $3D     ; multiplicant MSB
MULPLSB:    .EQU $3E     ; multiplier LSB
MULPMSB:    .EQU $3F     ; multiplier MSB

PRODLSB:    .EQU $40     ; product LSB
PRODMSB:    .EQU $41     ; product MSB
GRIDCOL     .EQU $42     ; survey site grid - column (vertical)
GRIDROW     .EQU $43     ; survey site grid - row (horizontal)
GRIDREFMSB: .EQU $44     ; address of byte to be stored. Chip 24LC256 has 32K bytes (8-bit)
GRIDREFLSB: .EQU $45     ; sq rt 32K = 180, therefore max grid that can be stored = 180 x 180
POLLCNT:    .EQU $46     ; serial eeprom use
RADDRH:     .EQU $47     ; serial eeprom read address
RADDRL:     .EQU $48
WADDRH:     .EQU $49     ; serial eeprom write address
WADDRL:     .EQU $4A
SLAVE:      .EQU $4B     ; serial eeprom use
TXBUF:      .EQU $4D
SAVEMSB:    .EQU $4E     ; value to be saved to serial eeprom
SAVELSB:    .EQU $4F

COLHEIGHT:  .EQU $50
ROWWIDTH:   .EQU $51
HIGHMSB:    .EQU $52
HIGHLSB:    .EQU $53
LOWMSB:     .EQU $54
LOWLSB:     .EQU $55
OCXFLAG      EQU $56
OCXSTORE     EQU $57
CURRENTREFMSB EQU $58
CURRENTREFLSB EQU $59
CURRENTVALMSB EQU $5A
CURRENTVALLSB EQU $5B



; IN ALL PAGES

AVRGCNT:    .EQU $70     ; average location store counter
LOOP:       .EQU $71     ; loop counter 1 - general
HIGH0MSB:   .EQU $72
HIGH0LSB:   .EQU $73
LOW0MSB:    .EQU $74
LOW0LSB:    .EQU $75
HIGH1MSB:   .EQU $76
HIGH1LSB:   .EQU $77
LOW1MSB:    .EQU $78
LOW1LSB:    .EQU $79
MIXHMSB:    .EQU $7A
MIXHLSB:    .EQU $7B
MIXLMSB:    .EQU $7C
MIXLLSB:    .EQU $7D
TEMPCNT:    .EQU $7E

               ; locations up to $7F are available

; IN PAGE 2

AVERAGE0:   .EQU $10     ; averaging store 0, extends to $4F

               ;........bit values

DI:         .EQU $07        ; eeprom input bit
DO:         .EQU $06        ; eeprom output bit
SDATA:      .EQU $04        ; serial EE data line (PORTC)
SCLK:       .EQU $03        ; serial EE clock line (PORTC)

                .ORG 0
                goto 5                  
                .ORG 4
                goto 5                  
                .ORG 5

START:          bcf STATUS,RP0
                bcf STATUS,RP1          
                clrf PORTA              
                clrf PORTB
                movlw %01000000
                movwf PORTC

                BANK1                   
                movlw %11111011     ; RA2 as output, RA0, RA1, RA3 as analog input
                movwf TRISA
                clrf TRISB
                clrf TRISC
                movlw %10101110     ; set RHS justify, RA0 as analog input, rest as digital I/O
                movwf ADCON1        ;
                movlw %00000100     ; timer 1:32, pull-ups on
                movwf OPTION_REG    ;
                BANK0                   
                movlw %01000001     ; set AD on, Fosc/8
                movwf ADCON0
                call PAUSIT             

                goto SETUP

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end inititalisation table

MESSAG1: addwf PCL,F
        retlw 'S'
        retlw 'O'
        retlw 'I'
        retlw 'L'
        retlw ' '
        retlw 'R'
        retlw 'E'
        retlw 'S'
        retlw 'I'
        retlw 'S'
        retlw 'T'
        retlw 'I'
        retlw 'V'
        retlw 'I'
        retlw 'T'
        retlw 'Y'

MESSAG2: addwf PCL,F
        retlw 'C'
        retlw 'L'
        retlw 'E'
        retlw 'A'
        retlw 'R'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'E'
        retlw 'E'
        retlw 'P'
        retlw 'R'
        retlw 'O'
        retlw 'M'
        retlw ' '

MESSAG3: addwf PCL,F
        retlw 'S'
        retlw 'E'
        retlw 'N'
        retlw 'D'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'T'
        retlw 'O'
        retlw ' '
        retlw 'P'
        retlw 'C'
        retlw ' '
        retlw ' '
        retlw ' '

MESSAG4: addwf PCL,F
        retlw 'S'
        retlw 'E'
        retlw 'N'
        retlw 'D'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'F'
        retlw 'I'
        retlw 'N'
        retlw 'I'
        retlw 'S'
        retlw 'H'
        retlw 'E'
        retlw 'D'

MESSAG5: addwf PCL,F
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw 'O'
        retlw 'F'
        retlw ' '
        retlw '3'
        retlw '2'
        retlw '7'
        retlw '6'
        retlw '8'
        retlw ' '

MESSAG7    addwf PCL,F
           retlw 'S'
           retlw 'E'
           retlw 'R'
           retlw 'I'
           retlw 'A'
           retlw 'L'
           retlw ' '
           retlw 'P'
           retlw 'O'
           retlw 'R'
           retlw 'T'
           retlw ' '
           retlw ' '
           retlw ' '
           retlw ' '
           retlw ' '

MESSAGEJ   addwf PCL,F
           retlw 'S'
           retlw 'E'
           retlw 'R'
           retlw 'I'
           retlw 'A'
           retlw 'L'
           retlw ' '
           retlw 'O'
           retlw 'C'
           retlw 'X'
           retlw ' '
           retlw 'T'
           retlw 'O'
           retlw ' '
           retlw 'P'
           retlw 'C'

MESSAGEREF addwf PCL,F
           retlw ' '
           retlw 'R'
           retlw 'E'
           retlw 'F'
           retlw ' '
           retlw 'S'
           retlw 'A'
           retlw 'V'
           retlw 'E'
           retlw 'D'
           retlw ' '
           retlw ' '
           retlw ' '
           retlw ' '
           retlw ' '
           retlw ' '
           retlw ' '

SETUP:  call PAUSIT     ;1st 1/5th sec delay
LCDSET: clrf LOOP       ;clr LCD set-up loop
        clrf RSLINE     ;clear RS line for instruction send
LCDST2: movf LOOP,W     ;get table address
        call TABLCD     ;get set-up instruction
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,3    ;has last LCD set-up instruction now been done?
        goto LCDST2     ;no
        call PAUSIT
        call SHOWTITLE

        clrf AVRGCNT
        movlw 2         ;initial basic CLKCNT val for secs timing
        movwf CLKCNT

        movlw %00000100
        movwf SQUAREWAVE
        movwf PORTA

        clrf CHAN
        clrf TMR0
        movlw 1
        movwf MODE

        clrf GRIDROW
        clrf GRIDCOL
        clrf GRIDREFMSB
        clrf GRIDREFLSB
        movlw %00000011
        movwf CURRENTREFMSB
        movlw %11111111
        movwf CURRENTREFLSB

        btfsc PORTA,5   ; is serial eeprom clearance needed?
        call CLEARIT    ; yes

        clrf OCXFLAG
        btfsc PORTC,2   ; is serial path change required?
        call SETOCX
        movlw 2
        call PRMGET
        movwf OCXFLAG
        movwf STORE1
        movlw 3
        call SETPRM


        movlw 0        ; get previous serial eeprom address
        call PRMGET
        andlw 127
        movwf GRIDCOL
        movlw 1
        call PRMGET
        andlw 127
        movwf GRIDROW

        movlw 4
        call PRMGET
        movwf CURRENTREFMSB
        movlw 5
        call PRMGET
        movwf CURRENTREFLSB

        movlw 127
        movwf ROWWIDTH
        movlw 127
        movwf COLHEIGHT
        call SHOWGRID

         btfss OCXFLAG,0
         goto SETNORM
         call JOESETBAUD      ; set baud rate
         goto MAIN

SETNORM: call SETBAUD      ; set baud rate

;....start of main routine

MAIN:   clrf TEMPCNT
        BCF INTCON,2

INTRPT:  btfss INTCON,2  ; has a timer time-out been detected?
         goto INTRPT     ; no

CHECKS1: btfss PORTC,0   ; check S1 - dec count
         goto CHECKS2
         call INCIT
         goto CHECKS1

CHECKS2: btfss PORTC,1   ; check S2 - inc count
         goto CHECKS3
         call DECIT
         goto CHECKS2

CHECKS3: btfsc PORTC,2   ; check S3 - toggle between Row and Col
         call INCMODE

CHECKC5: btfsc PORTC,5   ; check RC5 - send to PC
         call DOWNLOAD

CHECKA5: btfsc PORTA,5   ; is save needed?
         call STOREIT    ; yes

GETADC:  bcf ADCON0,3    ; set for chan 0
         bcf ADCON0,4    ; set for chan 0
         call DELAYB

         bsf ADCON0,GO   ; yes, start data conversion
WAITAD0: btfsc ADCON0,GO ; wait conversion flag
         goto WAITAD0
         btfss PORTA,2   ; is it pulse high being monitored?
         goto ADC00      ; no

         movf ADRESH,W   ; yes - monitor probe 0 HIGH
         movwf HIGH0MSB
         BANK1
         movf ADRESL,W
         BANK0
         movwf HIGH0LSB
         goto GETADC2

ADC00:   movf HIGH0LSB,W    ; subtract HIGH from CURRENTREF
         subwf CURRENTREFLSB,W  ; putting answer in CURRENTVAL
         movwf CURRENTVALLSB

         movf HIGH0MSB,W    ; put HIGH MSB into temp store
         movwf COUNT0

         btfss STATUS,C    ; is there a borrow?
         incf COUNT0,F    ; yes, so inc val of next byte to be subtracted
         movf COUNT0,W    ; subtract LOW from HIGH MSB
         subwf CURRENTREFMSB,W
         movwf CURRENTVALMSB
         btfsc STATUS,C    ; is there a borrow?
         goto ADC00X       ; no
         clrf CURRENTVALLSB ; yes, so set CURRENTVAL to 0
         clrf CURRENTVALMSB

ADC00X:   movf CURRENTVALMSB,F  ; is CURRENTVAL>=256?
          btfss STATUS,Z
          goto ADC01X           ; yes
          movf CURRENTVALLSB,W  ; is val >63?
          andlw %11000000
          btfsc STATUS,Z
          goto ADC02X           ; no
ADC01X:   movlw 63 
          movwf CURRENTVALLSB
          clrf CURRENTVALMSB
ADC02X 
      

GETADC2: bsf ADCON0,3      ; set for chan 1
         call DELAYB
         bsf ADCON0,GO     ; yes, start data conversion
WAITAD01: btfsc ADCON0,GO  ; wait conversion flag
         goto WAITAD01
         btfss PORTA,2     ; is pulse high being monitored?
         goto ADC10        ; no

         movf ADRESH,W     ; yes - monitor probe 1 HIGH
         movwf HIGH1MSB
         BANK1
         movf ADRESL,W
         BANK0
         movwf HIGH1LSB
         goto GETADC3

ADC10:   movf ADRESH,W     ; get probe 1 LOW
         movwf LOW1MSB
         BANK1
         movf ADRESL,W
         BANK0
         movwf LOW1LSB

         movf LOW1LSB,W    ; subtract LOW from HIGH LSB only done after low has been taken
         subwf HIGH1LSB,F  ; leaving answer in HIGH
         btfss STATUS,C    ; is there a borrow?
         incf LOW1MSB,F    ; yes, so inc val of next byte to be subtracted
         movf LOW1MSB,W    ; subtract LOW from HIGH MSB
         subwf HIGH1MSB,F
         btfsc STATUS,C    ; is there a borrow?
         goto GETADC3      ; no
         comf HIGH1MSB,F   ; yes, so invert answer
         comf HIGH1LSB,F
         incf HIGH1LSB,F

GETADC3: bsf ADCON0,3      ; set for chan 3
         bsf ADCON0,4      ; set for chan 3
         call DELAYB
         bsf ADCON0,GO     ; yes, start data conversion
WAITAD03: btfsc ADCON0,GO  ; wait conversion flag
         goto WAITAD03
         btfss PORTA,2     ; is pulse high being monitored?
         goto ADC30        ; no

         movf ADRESH,W     ; yes - get mixed result HIGH clock
         movwf MIXHMSB
         movwf HIGHMSB
         BANK1
         movf ADRESL,W
         BANK0
         movwf MIXHLSB
         movwf HIGHLSB
         goto TOG5

ADC30: ; goto TOG5   ;**** reinstate temporarily to check baud rate on freq counter

         movf ADRESH,W     ; get mixed result LOW clock
         movwf MIXLMSB
         movwf LOWMSB
         BANK1
         movf ADRESL,W
         BANK0
         movwf MIXLLSB
         movwf LOWLSB

         movf MIXLLSB,W    ; subtract LOW from HIGH LSB only done after low has been taken
         subwf MIXHLSB,F   ; leaving answer in HIGH
         btfss STATUS,C    ; is there a borrow?
         incf MIXLMSB,F    ; yes, so inc val of next byte to be subtracted
         movf MIXLMSB,W    ; subtract LOW from HIGH MSB
         subwf MIXHMSB,F
         btfsc STATUS,C    ; is there a borrow?
         goto ADC31 
         comf MIXHMSB,F    ; yes, so invert answer
         comf MIXHLSB,F
         incf MIXHLSB,F

ADC31:   BLOCK1
         movlw AVERAGE0    ; store answer for averaging
         addwf AVRGCNT,W
         movwf FSR
         movf MIXHLSB,W
         movwf INDF
         incf FSR,F
         movf MIXHMSB,W
         movwf INDF
         BLOCK0

         movlw 2           ; inc average counter by 2 only done after all 3 pairs taken
         addwf AVRGCNT,F
         bcf AVRGCNT,6     ; limit to 64 (32 samples)

         decfsz CLKCNT,F
         goto TOG5
         call LCD1
         bsf RSLINE,4

         btfsc PORTA,4
         goto HIMIX
PROBE0:  movf HIGH1MSB,W
         movwf COUNT1
         movf HIGH1LSB,W
         movwf COUNT0
         goto SHOW0

HIMIX:   movf LOWMSB,W
         movwf COUNT1
         movf LOWLSB,W
         movwf COUNT0

SHOW0:   clrf COUNT2
         call BIN2DEC
         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         movlw 'B'
         btfsc PORTA,4
         movlw 'H'
         call LCDOUT

         btfsc PORTA,4
         goto LOMIX

PROBE1:  clrf COUNT1

         movf CURRENTVALLSB,W    ; copy CURRENTREF into count0
         movwf COUNT0
         xorlw 63                ; is val = 63 (maximum allowed)?
         btfss STATUS,Z
         goto SHOW1              ; no
         movlw ' '
         call LCDOUT
         movlw 'M'
         call LCDOUT
         movlw 'A'
         call LCDOUT
         movlw 'X'
         call LCDOUT
         movlw ' '
         call LCDOUT
         goto AVCALC

LOMIX:   movf HIGHMSB,W
         movwf COUNT1
         movf HIGHLSB,W
         movwf COUNT0

SHOW1:   clrf COUNT2
         call BIN2DEC
         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         movlw 'A'
         btfsc PORTA,4
         movlw 'L'
         call LCDOUT

AVCALC   BLOCK1                ; show mix value
         movlw AVERAGE0        ; get average of 32 samples
         movwf FSR             ; and use for further calcs
         BLOCK0
         call GETAVERAGE

         movf DIGIT2,W         ; is it >= 512?
         andlw %11111110
         btfsc STATUS,Z
         goto AVCALC2
         movlw 1
         movwf DIGIT2
         movwf SAVEMSB         ; store mix val MSB
         movlw 255
         movwf DIGIT1
         movwf SAVELSB         ; store mix val MSB
         movlw ' '
         call LCDOUT 
         movlw ' '
         call LCDOUT 
         movlw 'M'
         call LCDOUT 
         movlw 'A'
         call LCDOUT 
         movlw 'X'
         call LCDOUT 
         movlw '#'
         call LCDOUT 
         goto TOG5

AVCALC2: movf DIGIT2,W
         movwf SAVEMSB         ; store mix val MSB
         movwf COUNT1
         movf DIGIT1,W
         movwf SAVELSB         ; store mix val MSB
         movwf COUNT0
         clrf COUNT2
         call BIN2DEC
         movlw ' '
         call LCDOUT 
         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         movlw '#'
         call LCDOUT 

TOG5:    comf SQUAREWAVE,F   ; toggle output
         movf SQUAREWAVE,W
         andlw %00000100
         bcf PORTA,2
         iorwf PORTA,F

;         movlw 169       ; 137Hz setting value (for 3.2768 xtal)
         movlw 157       ; 137Hz setting value (for 3.6864 xtal)
         movwf TMR0      ; reset timer
         bcf INTCON,2
         goto INTRPT

;******** LCD ROUTINES **********

LCD1:   movlw %10000000
        goto LCDLIN
LCD13   movlw B'10001100'
        goto LCDLIN
LCD21:  movlw %11000000
        goto LCDLIN
LCD27:  movlw %11001110
        goto LCDLIN
LCD2B:  movlw %11001011

LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE1    ;temp store value that will be output to LCD
        movlw 60        ;set minimum time between sending full bytes to
        movwf LOOPA     ;LCD - value of 60 seems OK for this prog with
DELAY:  decfsz LOOPA,F  ;XTAL clk of upto 5MHz, possibly 5.5MHz
        goto DELAY
        call SENDIT     ;send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ;swap byte nibbles
        movf STORE1,W   ;get nibble (MSB)
        andlw 15        ;AND to isolate nibble
        iorwf RSLINE,W  ;OR the RS bit
        movwf PORTB     ;output the byte
        BSF PORTB,5     ;set E high
        BCF PORTB,5     ;set E low
        return

LCDFRM:         movwf STORE2            ;split & format decimal byte for lcd
                swapf STORE2,W          ;swap byte into w to get tens
                andlw 15                ;and to get nibble
                iorlw 48                ;or with 48 to make ascii value
                call LCDOUT             ;send to lcd
                movf STORE2,W           ;get units
                andlw 15                ;and to get nibble
                iorlw 48                ;or with 48 to make ascii value
                call LCDOUT             ;send to lcd
                return                  

;............

PAUSIT: movlw 20         ;1/5th sec wait set
        movwf CLKCNT
        clrf INTCON     ;clear interupt flag
PAUSE:                  ;initial 1/5th sec wait before setting up LCD
        btfss INTCON,2  ;has a timer time-out been detected?
        goto PAUSE      ;no
        BCF INTCON,2    ;yes
        decfsz CLKCNT,F ;dec loop, is it zero?
        goto PAUSE      ;no
        return          ;yes

;************

BIN2DEC: clrf   DIGIT1
        clrf    DIGIT2
        clrf    DIGIT3
        clrf    DIGIT4
        clrf    DIGIT5
        clrf    DIGIT6
        clrf    DIGIT7
        clrf    DIGIT8

        movlw   24              ;24 bits to do
        movwf   BITCNT

BITLP:  rlf     COUNT0,F        ;Shift msb into carry
        rlf     COUNT1,F
        rlf     COUNT2,F

        movlw   DIGIT1
        movwf   FSR             ;Pointer to DIGITs
        movlw   8               ;8 DIGITs to do
        movwf   DIGCNT
ADJLP:  rlf     INDF,F          ;Shift DIGIT 1 bit left
        movlw   10
        subwf   INDF,w          ;Check and adjust for decimal overflow
        skpnc
        movwf   INDF

        incf    FSR,F           ;Next DIGIT
        decfsz  DIGCNT,F
        goto    ADJLP
        decfsz  BITCNT,F        ;Next bit
        goto    BITLP
        movlw 48
        iorwf DIGIT1,F       ; convert to ascii numeral
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F

        movf DIGIT8,W       ; blank leading zeros
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        movf DIGIT7,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT7,4
        movf DIGIT6,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT6,4
        movf DIGIT5,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT5,4
        movf DIGIT4,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT4,4
        movf DIGIT3,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT3,4
        movf DIGIT2,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT2,4
        movf DIGIT8,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        return

;*************

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

;*********

GETAVERAGE: clrf LOOP
        clrf DIGIT1
        clrf DIGIT2
        clrf DIGIT3

GETAV1: BLOCK1
        movf INDF,W
        BLOCK0

        addwf DIGIT1,F
        movf STATUS,W
        andlw 1
        addwf DIGIT2,F
        movf STATUS,W
        andlw 1
        addwf DIGIT3,F

        BLOCK1
        incf FSR,F
        movf INDF,W
        BLOCK0

        addwf DIGIT2,F
        movf STATUS,W
        andlw 1
        addwf DIGIT3,F

        BLOCK1
        incf FSR,F
        BLOCK0

        movlw 2
        addwf LOOP,F
        btfss LOOP,6
        goto GETAV1

        bcf STATUS,C          ; divide by 32
        rrf DIGIT3,F
        rrf DIGIT2,F
        rrf DIGIT1,F
        bcf STATUS,C
        rrf DIGIT3,F
        rrf DIGIT2,F
        rrf DIGIT1,F
        bcf STATUS,C
        rrf DIGIT3,F
        rrf DIGIT2,F
        rrf DIGIT1,F
        bcf STATUS,C
        rrf DIGIT3,F
        rrf DIGIT2,F
        rrf DIGIT1,F
        bcf STATUS,C
        rrf DIGIT3,F
        rrf DIGIT2,F
        rrf DIGIT1,F
        return

;*********

;SERIALMEM01 30MAR02 from LOG430.ASM 29OCT99 - JOHN BECKER - EPE DATA LOGGER MODIFIED EXTRACT

SAVESAMPLE:

WRMSB:  movf MEMHI,W       ; store MSB
        call WRBYTE
        incf WADDRL,F      ; inc address
WRLSB:  movf MEMLO,W       ; store LSB
        call WRBYTE
        decf WADDRL,F      ; return address to prev value
        return

;..............

;CONVERTED MPASM FILE C:\ASMCNV\2WDPOLL.ASM
;       TO TASM  FILE C:\PIC\2WDPOLL.ASM 03-12-1999 19:28:42

          ;***************************************************************
          ;       Byte Write Routine with data polling
          ;***************************************************************

WRBYTE:   movwf DATAO         ;entry with val to send in W, stored to DATAO
          movlw %10100000     ; set slave address and write mode
          MOVWF SLAVE

BYTE:     CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; move slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRL,W       ; send address low byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          MOVF DATAO,W        ; move data byte
          MOVWF TXBUF         ; to tranmit buffer
          CALL TX             ; and transmit it
          CALL BSTOP          ; generate stop bit

          MOVLW 40            ; now start polling for a low ack bit
          MOVWF POLLCNT       ; set max number of times to poll
POLL:     CALL BSTART         ; generate start bit
          movlw %10100000     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it
          BTFSS EEPROM,DI     ; was the ack bit low?
          GOTO EXITPOLL       ; yes, do another byte
          DECFSZ POLLCNT,F    ; is poll counter down to zero?
          GOTO POLL           ; no, poll again.
EXITPOLL: return

          ;**************************************************************
          ;       Start Bit Subroutine - generates a start bit
          ;       (Low going data line while clock is high)
          ;**************************************************************

BSTART:   BSF PORTC,SDATA    ; make sure data is high
          BANK1
          MOVLW %10100111
          MOVWF TRISC         ; set data and clock lines for output
          BANK0
          BCF PORTC,SCLK     ; make sure clock is low
          NOP                 
          BSF PORTC,SCLK     ; set clock high
          NOP                 
          NOP                 
          NOP                 
          NOP                 
          NOP                 
          BCF PORTC,SDATA    ; data line goes low during
                              ; high clock for start bit
          NOP                 
          NOP                 
          NOP                 
          NOP                 
          NOP                 ; timing adjustment
          BCF PORTC,SCLK     ; start clock train
          NOP                 
          NOP                 
          RETLW 0             

          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP:    BANK1
          MOVLW %10100111
          MOVWF TRISC         ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA    ; make sure data line is low
          NOP                 
          NOP                 
          NOP                 
          BSF PORTC,SCLK     ; set clock high
          NOP                 
          NOP                 
          NOP                 
          BSF PORTC,SDATA    ; data goes high while clock high
                              ; for stop bit
          NOP                 
          NOP                 
          BCF PORTC,SCLK     ; set clock low again
          NOP                 
          NOP                 
          NOP                 
          RETLW 0             

            ;*************************************************************
            ;       BITOUT routine takes one bit of data in 'do' and
            ;       transmits it to the serial EE device
            ;*************************************************************

BITOUT:   BANK1
          MOVLW %10100111
          MOVWF TRISC
          BANK0
          BTFSS EEPROM,DO    ; check for state of data bit to xmit
          GOTO BITLOW        ;
          BSF PORTC,SDATA    ; set data line high
          GOTO CLKOUT        ; go toggle the clock

BITLOW:   BCF PORTC,SDATA    ; output a low bit
CLKOUT:   BSF PORTC,SCLK     ; set clock line high
          NOP                 
          NOP                 
          NOP                 
          NOP                 
          BCF PORTC,SCLK     ; return clock line low
          RETLW 0             

          ;**************************************************************
          ;       BITIN routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN:    BSF EEPROM,DI       ; assume input bit is high
          BANK1
          MOVLW %10110111     ; make sdata an input line
          MOVWF TRISC
          BANK0
          BSF PORTC,SDATA    ; set sdata line for input
          BSF PORTC,SCLK     ; set clock line high
          NOP                ; just sit here fractionally
          NOP                 
          NOP                 
          NOP                 
          NOP
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI      ; input bit was low
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX:       MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP:     BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; otherwise data bit =1
          CALL BITOUT         ; serial data out
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP           ; no - go again
          CALL BITIN          ; read ack bit
          RETLW 0             

                              
;CONVERTED MPASM FILE C:\ASMCNV\2WSEQR.ASM
;       TO TASM  FILE C:\PIC\2WSEQR.ASM 03-12-1999 19:29:04

          ;************************************************************
          ;       2-Wire Sequential Read Program
          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP2:   BANK1
          MOVLW %10100111     ;
          MOVWF TRISC         ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA     ; make sure data line is low
          NOP                 
          NOP                 
          NOP                 
          BSF PORTC,SCLK      ; set clock high
          NOP                 
          NOP                 
          NOP                 
          BSF PORTC,SDATA     ; data goes high while clock high
          NOP                 ; for stop bit
          NOP                 
          BCF PORTC,SCLK      ; set clock low again
          NOP                 
          NOP                 
          NOP                 
          RETLW 0             

          ;**************************************************************
          ;       BITIN2 routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN2:   BSF EEPROM,DI       ; assume input bit is high
          BANK1
          MOVLW %10110111     ; make sdata an input line
          MOVWF TRISC
          BANK0
          BSF PORTC,SCLK      ; set clock line high
          NOP                 ; just sit here a sec
          NOP                 
          NOP                 
          NOP                 
          NOP                 ;
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI       ; input bit was low, set 'di' accordingly
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0             

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX2:      MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP2:    BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; no, set it high
          CALL BITOUT         ; send the bit to serial EE
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP2          ; no - go again
          CALL BITIN2         ; read ack bit
          BTFSC EEPROM,DI     ; check ack bit
          NOP
          RETLW 0             

          ;****************************************************************
          ;       Receive data Routine
          ;****************************************************************

RX:       MOVLW 8             ; set # bits to 8
          MOVWF COUNT         
          CLRF DATAI          ; clear input register
          BCF STATUS,0        ; make sure carry bit is low
RXLP:     RLF DATAI,F         ; rotate DATAI 1 bit left
          CALL BITIN2         ; read a bit
          BTFSC EEPROM,DI     
          BSF DATAI,0         ; set bit 0 if necessary
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO RXLP           ; no, do another
          RETLW 0             

          ;**************************************************************
          ;       READ (sequential read routine)
          ;**************************************************************

READ:     MOVLW 2             
          MOVWF BCOUNT        ; set number of bytes to read
          movlw %10100000     ; set slave address and write mode
          MOVWF SLAVE         

          CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; get slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          movf RADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          MOVF RADDRL,W       ; get word address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          CALL BSTART         ; generate start bit
          movlw %10100001     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and transmit it
                              ;
RBYTE:    CALL RX             ; read 1 byte from device
          DECFSZ BCOUNT,F     ; are both bytes read?
          GOTO LOWACK         ; no, send low ack and do another
          BSF EEPROM,DO       ; yes, send high ack bit
          CALL BITOUT         ; to stop transmission
          CALL BSTOP2         ; and send a stop bit
          movf DATAI,W
          movwf COUNT0
          movwf MEMLO         ;data low byte
          return

LOWACK:   movf DATAI,W
          movwf COUNT1
          movwf MEMHI         ; data high byte
          BCF EEPROM,DO       ; send low ack bit
          CALL BITOUT         ; to continue transmission
          GOTO RBYTE          ; and read another byte

;*************** OUTPUT EEPROM CHIPS TO PC SERIAL PORT

DOWNLOAD btfsc OCXFLAG,0
         goto JOEDOWNLOAD

        call CLRLINE2
        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWMSG2: movf LOOP,W
        call MESSAG3          ; sending to PC
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMSG2

        call SENDDOWNLOAD

        clrf LOOP
        call LCD21
        bsf RSLINE,4
SHOWMSG4: movf LOOP,W
        call MESSAG4          ; finished sending
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMSG4

WAIT34: btfsc PORTC,5
        goto WAIT34           ; wait till switches released
        call PAUSIT
        call SHOWTITLE
        return

;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

SENDDOWNLOAD:
          BANK1
          bsf TXSTA,5         ;enable transmission (bit TXEN)
          BANK0

        clrf RADDRH
        clrf RADDRL
        clrf CHAN

        clrf LOOP
        movlw 0
        call SERIALSEND
        movlw 255
        call SERIALSEND
        movlw 0
        call SERIALSEND
        movlw 0
        call SERIALSEND
        movlw 0
        call SERIALSEND
        movlw 0
        call SERIALSEND

        movlw 'R'
        call SERIALSEND
        movlw 'E'
        call SERIALSEND
        movlw 'S'
        call SERIALSEND
        movlw 'I'
        call SERIALSEND
        movlw 'S'
        call SERIALSEND
        movlw 'T'
        call SERIALSEND
        movlw 'Y'
        call SERIALSEND

SER3A:  call READ        ; temp delete

;        incf TEMPCNT,F   ; temp - outputs values from 0 to 255
;        movf TEMPCNT,W   ; temp
;        movwf COUNT0     ; temp
;        clrf COUNT1      ; temp

;        movf RADDRL,W
;        movwf COUNT0     ; temp
;        movf RADDRH,W
;        movwf COUNT1     ; temp

        bcf STATUS,C
        rlf COUNT0,W     ; limit val of LSB to 127 max
        rlf COUNT1,F     ; with its bit 7 rotated into COUNT1 (MSB)
        bcf COUNT0,7
        bsf COUNT1,7

        movf COUNT0,W
        call SERIALSEND

        movf COUNT1,W
        call SERIALSEND
        movlw 2
        addwf RADDRL,F    ;inc read address by 2
        btfss STATUS,C
        goto SER3A
        incf RADDRH,F
        movf RADDRH,W
        xorlw %10000000
        btfss STATUS,Z
        goto SER3A

        movlw 0
        call SERIALSEND
        movlw 255
        call SERIALSEND
        movlw 0
        call SERIALSEND
        movlw 0
        call SERIALSEND
        movlw 0
        call SERIALSEND
        movlw 0
        call SERIALSEND

        movlw 'R'
        call SERIALSEND
        movlw 'E'
        call SERIALSEND
        movlw 'S'
        call SERIALSEND
        movlw 'I'
        call SERIALSEND
        movlw 'S'
        call SERIALSEND
        movlw 'T'
        call SERIALSEND
        movlw 'Y'
        call SERIALSEND
        return

SERIALSEND: btfss PIR1,4  ;wait for TXIF bit 4 to go high (showing TXREG empty)
        goto SERIALSEND
        movwf TXREG   ;put val (held in W) in TXREG ready for transmission
        return

;**************

SETBAUD:  BANK1

         movlw 23            ; BRG for 9600baud from 3.6864MHz, brgh=1

;          movlw 20            ; BRG for 9600baud from 3.2768MHz, brgh=1

          movwf SPBRG
          movlw %00000100     ; set sync=0, brgh=1 + ninth bit not set
          movwf TXSTA         ; it is essential to set 9th bit when data
                              ; is output to QBasic

          bcf PIE1,4          ;clear interrupt bit (bit TXIE)
          BANK0

          movlw %10000000     ;set SPEN Bit of RCSTA reg
          movwf RCSTA
          return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE1.
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        movf STORE1,W   ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

;****************

;A neat Multiply routine, from Peter Hemsley 15July01.

;Multiply 16 bit multiplicand (mulcL,H) by 16 bit multiplier (mulpL,H)
;32 bit result (product) in mulpL,H (low word) and prodL,H (high word)

MULTIPLY: movlw  16        ; B'00010000' H'10'
          movwf  BITCNT  
          clrf   PRODLSB  
          clrf   PRODMSB  
JMP0014:  bcf    STATUS,0
          btfss  MULPLSB,0
          goto   JMP0028
          movf   MULCLSB,W
          addwf  PRODLSB,F
          movf   MULCMSB,W
          btfsc  STATUS,0
          goto   JMP0024
          addwf  PRODMSB,F
          goto   JMP0028
JMP0024:  addwf  PRODMSB,F
          incf   PRODMSB,F
          btfsc  STATUS,2
          bsf    STATUS,0
JMP0028:  rrf    PRODMSB,F
          rrf    PRODLSB,F
          rrf    MULPMSB,F
          rrf    MULPLSB,F
          decfsz BITCNT,F
          goto   JMP0014
          return 

;**************

DELAYB:   nop
          nop
          nop
          nop
          nop
          nop
          nop
          return

INCMODE:  incf MODE,F
          call SHOWGRID

INCM2:   btfss PORTC,2   ; check S3 - toggle between Row and Col
         return        
         btfss PORTA,5
         goto INCM2
         movf HIGH0MSB,W
         movwf CURRENTREFMSB
         movwf COUNT1
         movf HIGH0LSB,W
         movwf CURRENTREFLSB
         movwf COUNT0
         clrf COUNT2
         call LCD21
         bsf RSLINE,4

         call BIN2DEC
         movf DIGIT5,W
         call LCDOUT
         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         clrf LOOP

         movf CURRENTREFMSB,W
         movwf STORE1
         movlw 4
         call SETPRM
         movf CURRENTREFLSB,W
         movwf STORE1
         movlw 5
         call SETPRM

SHOWREF  movf LOOP,W
         call MESSAGEREF   ; show reference value stored
         call LCDOUT
         incf LOOP,F
         btfss LOOP,4
         goto SHOWREF 

INCM3:   btfsc PORTA,5
         goto INCM3
         call CLRLINE2
         call SHOWGRID
         return

SHOWGRID: call LCD21
         bsf RSLINE,4

         movf GRIDCOL,W
         movwf COUNT0
         clrf COUNT1
         clrf COUNT2
         call BIN2DEC
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         movlw 'C'
         call LCDOUT 
         movlw ' '
         btfsc MODE,0
         movlw '*'
         call LCDOUT

         movf GRIDROW,W
         movwf COUNT0
         clrf COUNT1
         clrf COUNT2
         call BIN2DEC
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         movlw 'R'
         call LCDOUT 
         movlw ' '
         btfss MODE,0
         movlw '*'
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw '='
         call LCDOUT

        movf GRIDROW,W      ; multiply col value by row width
        movwf MULCLSB       
        clrf MULCMSB
        incf COLHEIGHT,W
        movwf MULPLSB
        clrf MULPMSB
        call MULTIPLY

        movf MULPLSB,W
        movwf GRIDREFLSB
        movf MULPMSB,W
        movwf GRIDREFMSB

        movf GRIDCOL,W      ; add GRIDROW
        addwf GRIDREFLSB,F
        btfsc STATUS,C
        incf GRIDREFMSB,F

        bcf STATUS,C
        rlf GRIDREFLSB,F    ; multiply * 2
        rlf GRIDREFMSB,F

         movf GRIDREFMSB,W
         movwf RADDRH      ; inc address
         movf GRIDREFLSB,W
         movwf RADDRL      ; inc address
         call READ

         movlw %00000001   ; exclude CURRENTVAL
         andwf COUNT1,F

         clrf COUNT2
         call BIN2DEC

         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT

         call PAUSIT
         call PAUSIT
         return

;********

STOREIT: movf SAVEMSB,W    ; store to serial EEPROM
         movwf MEMHI

         bcf STATUS,C      ; OR in CURRENTVAL x 2
         rlf CURRENTVALLSB,W
         iorwf MEMHI,F

         movf SAVELSB,W
         movwf MEMLO

         movf GRIDREFMSB,W
         movwf WADDRH      ; set address MSB
         movf GRIDREFLSB,W
         movwf WADDRL      ; set address LSB
         call SAVESAMPLE

         movf GRIDCOL,W
         movwf STORE1
         movlw 0
         call SETPRM
         movf GRIDROW,W
         movwf STORE1
         movlw 1
         call SETPRM

         call CLRLINE2
         call LCD21
         bsf RSLINE,4

         movlw 'S'
         call LCDOUT
         movlw 'A'
         call LCDOUT
         movlw 'V'
         call LCDOUT
         movlw 'E'
         call LCDOUT
         movlw 'D'
         call LCDOUT

         movf GRIDREFMSB,W
         movwf RADDRH      ; inc address
         movf GRIDREFLSB,W
         movwf RADDRL      ; inc address
         call READ

         movlw %00000001    ; exclude CURRENTVAL
         andwf COUNT1,F

         clrf COUNT2
         call BIN2DEC

         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT
         movlw ' '
         call LCDOUT 
         movlw '>'
         call LCDOUT 

         movf GRIDREFMSB,W
         movwf COUNT1
         movf GRIDREFLSB,W
         movwf COUNT0
         clrf COUNT2
         call BIN2DEC
         movf DIGIT5,W
         call LCDOUT
         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT

WAITA5:  btfsc PORTA,5       ; wait till switch released
         goto WAITA5

         call SHOWGRID
         return

INCIT:   btfss MODE,0     ; is MODE 0 = 0 ?
         goto INCROW      ; no, = 1
INCCOL:  incf GRIDCOL,F   ; yes
         decf GRIDCOL,W   ; is it > col height?
         xorwf COLHEIGHT,W
         btfsc STATUS,Z
         clrf GRIDCOL     ; yes, so reset it
         goto SHOWGRID
INCROW:  incf GRIDROW,F
         decf GRIDROW,W   ; is it > than ROWWIDTH
         xorwf ROWWIDTH,W
         btfsc STATUS,Z
         clrf GRIDROW     ; yes, so reset it

         goto SHOWGRID

DECIT:   btfss MODE,0     ; is MODE 0 = 0 ?
         goto DECROW      ; no, = 1
DECCOL:  decf GRIDCOL,F   ; yes
         incf GRIDCOL,W   ; is it less than 0 (ie. = 255)?
         btfss STATUS,Z
         goto SHOWGRID
         movf COLHEIGHT,W
         movwf GRIDCOL     ; yes, so reset it
         goto SHOWGRID
DECROW:  decf GRIDROW,F
         incf GRIDROW,W   ; is it less than 0 (ie. = 255)?
         btfss STATUS,Z
         goto SHOWGRID
         movf ROWWIDTH,W
         movwf GRIDROW     ; yes, so reset it
         goto SHOWGRID

;.............

CLEARIT: call CLRLINE1
        call CLRLINE2

        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWCLR: movf LOOP,W
        call MESSAG2          ; clearing eeprom
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCLR

        clrf LOOP
        call LCD21
        bsf RSLINE,4
SHOWCL2: movf LOOP,W
        call MESSAG5          ; clearing eeprom
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCL2

         clrf MEMHI        ; clear entire serial eeprom
         clrf MEMLO
         clrf WADDRH      ; set write address MSB
         clrf WADDRL      ; set write address LSB

CLEAR2: movf WADDRH,W
        movwf COUNT1
        movf WADDRL,W
        movwf COUNT0
        clrf COUNT2
        call BIN2DEC
        call LCD21
        bsf RSLINE,4
         movf DIGIT6,W
         call LCDOUT
         movf DIGIT5,W
         call LCDOUT
         movf DIGIT4,W
         call LCDOUT
         movf DIGIT3,W
         call LCDOUT
         movf DIGIT2,W
         call LCDOUT
         movf DIGIT1,W
         call LCDOUT

        call SAVESAMPLE
        movlw 2
        addwf WADDRL,F    ;inc write address by 2
        btfss STATUS,C
        goto CLEAR2
        incf WADDRH,F
        btfss WADDRH,7
        goto CLEAR2

         movf GRIDCOL,W
         movwf STORE1
         movlw 0
         call SETPRM
         movf GRIDROW,W
         movwf STORE1
         movlw 1
         call SETPRM

CLEAR3: btfsc PORTA,5   ; is switch released?
        goto CLEAR3     ; no
        call SHOWTITLE
        return          ; yes

SHOWTITLE: clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWMS1: movf LOOP,W
        call MESSAG1          ; soil resistivity
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMS1
        return


SETOCX   call CLRLINE1
        call CLRLINE2

         clrf LOOP
         call LCD1
         bsf RSLINE,4
SHOWMSG3 movf LOOP,W
         call MESSAG7     ; serial port message
         call LCDOUT
         incf LOOP,F
         btfss LOOP,4
         goto SHOWMSG3

SETOCX2 call LCD13
        bsf RSLINE,4

        movlw 'N'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'M'
        call LCDOUT

        clrf OCXSTORE

        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT

        btfss PORTC,2
        goto ENDSETOCX

        call LCD13
        bsf RSLINE,4

        movlw 'O'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'X'
        call LCDOUT
        movlw ' '
        call LCDOUT

        bsf OCXSTORE,0

        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT

        btfss PORTC,2
        goto ENDSETOCX
        goto SETOCX2

ENDSETOCX 
        movf OCXSTORE,W
        movwf STORE1        ; OCXFLAG 

	movlw 2
	call SETPRM	
	call CLRLINE1
        call CLRLINE2

         btfss OCXFLAG,0
         goto SETNORM2
         call JOESETBAUD      ; set baud rate
         goto ENDSET2

SETNORM2: call SETBAUD      ; set baud rate

ENDSET2:
        call PAUSIT
        movlw 25
        movwf CLKCNT
        return
        
JOEDOWNLOAD call CLRLINE2     ; clear LCD line 2 (via include routine)
         clrf LOOP
         call LCD1
         bsf RSLINE,4
SHOWMSGJ movf LOOP,W
         call MESSAGEJ     ; sending to PC message
         call LCDOUT
         incf LOOP,F
         btfss LOOP,4
         goto SHOWMSGJ
       
         call JOESENDPC

         movlw 25          ; reset clk counter
         movwf CLKCNT
         return 

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03
;---------------------------------------------------------------------
; Description:
; Sends 100 blocks of 258 bytes (256 data + 2 trailer) to the
; serial port.
; On receipt of a 'G' command from the PC, the PIC waits for 'B'
; command and then sends a 258 byte block. The PIC again waits for a 'B'
; command before sending the next block.
; The block being sent is reflected on the PORTB LEDS.
; Each block contains ASCII codes (0 to 255).
;
; The PIC waits for a character before sending back the ASCII block
;
;---------------------------------------------------------------------

JOESETBAUD
        BANK1                   ; Configure the baud rate generator
;        movlw   d'20'           ; 9600 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)
        movlw   d'23'           ; 9600 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)
	movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed) & ASYNC transmission
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call 	FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

JOESENDPC
         clrf RADDRH       ; reset start address for reading EEPROM chip
         clrf RADDRL

WaitG 				; Wait for any character to be received
        call 	FlushRXBuffer   ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        sublw   'G'             ; Is this a 'G'
        btfss   STATUS,Z
        goto    WaitG           ; Not a 'G'

; 'G' has been received - Confirm ready state back to PC
        movlw   'R'             ; Signal 'R'eady
        call    TxByte

; Start sending the blocks
; First, wait for the PC to send us a 'B' command (Send block)

WaitB
	call 	FlushRXBuffer   ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        movwf   PORTB
        sublw   'B'             ; Is this a 'B'
        btfss   STATUS,Z
        goto    WaitB           ; Not a 'B'

; 'B' received, send a block

SendNext
         call READ         ; read from EEPROM chip
         movf MEMLO,W      ; get LSB value
;        movf RADDRL,W
;;        andlw 127
         call TXBYTE       ; send it to PC
         movf MEMHI,W      ; get MSB value
;;        movlw 128
;;         movlw 0
;        movf RADDRH,W

         call TXBYTE       ; send it to PC
       
         movlw 2
         addwf RADDRL,F    ; inc read address by 2
         btfss STATUS,C
         goto SendNext

; Data portion of the block has been sent, now send the Block terminator
        movlw   0x0D            ; CR
        call    TxByte
        movlw   0x0A            ; LF
        call    TxByte

        incf RADDRH,F
        btfss RADDRH,7    ; is bit 7 of MSB high? (32768)
        goto    WaitB

        clrf RADDRH       ; reset start address for reading EEPROM chip
        clrf RADDRL
        return 

; Receive a character from RS232
; (This routine does not return until a character has been received)
; The received character is in the W register

RecLoop
        nop
        btfss   PIR1,RCIF       ; Check for any RX'd data
        goto 	RecLoop         ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

; Send a byte 'W' to the USART

TxByte
        nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

;**************

        ORG $2100
        DE 0,0,0,0,3,255

        .END

